DECLARE @T TABLE (object_name                                       sysname,
                  schema_name                                       sysname,
                  index_id                                          INT,
                  partition_number                                  INT,
                  size_with_current_compression_setting_Ko          BIGINT,
                  size_with_requested_compression_setting_Ko        BIGINT,
                  sample_size_with_current_compression_setting_Ko   BIGINT,
                  sample_size_with_requested_compression_setting_Ko BIGINT);
DECLARE @F TABLE (object_name                                       sysname,
                  schema_name                                       sysname,
                  index_id                                          INT,
                  partition_number                                  INT,
                  size_with_current_compression_setting_Ko          BIGINT,
                  size_with_requested_compression_setting_Ko        BIGINT,
                  sample_size_with_current_compression_setting_Ko   BIGINT,
                  sample_size_with_requested_compression_setting_Ko BIGINT,
                  compression_method CHAR(4));
DECLARE @s_name sysname, @o_name sysname, @idxid INT, @SQL NVARCHAR(max)

DECLARE C CURSOR
   LOCAL FORWARD_ONLY STATIC READ_ONLY
   FOR
      SELECT s.name AS s_name, o.name AS o_name, index_id
      FROM   sys.indexes AS i
             INNER JOIN sys.objects AS o
                   ON i.object_id = o.object_id
             INNER JOIN sys.schemas AS s
                   ON o.schema_id = s.schema_id
      WHERE  o."type" IN ('U', 'V')
        AND  is_ms_shipped = 0
        AND  index_id < 256
        AND  NOT EXISTS(SELECT *
                        FROM   INFORMATION_SCHEMA.COLUMNS
                        WHERE  TABLE_NAME = o.name
                          AND  TABLE_SCHEMA = s.name 
                          AND  DATA_TYPE IN ('geography', 'geometry', 'hierarchyid'));

OPEN C;

FETCH C INTO @s_name, @o_name, @idxid;

WHILE @@FETCH_STATUS = 0
BEGIN
   SET @SQL = N'EXEC sp_estimate_data_compression_savings '''
            + @s_name + N''', ''' + @o_name + N''', '
            + CAST(@idxid AS NVARCHAR(16)) +', NULL , ''PAGE'';';
PRINT @SQL --> pour vrification, peut tre supprim !
   INSERT INTO @T
   EXEC (@SQL);
   INSERT INTO @F
   SELECT *, 'PAGE' FROM @T;
   DELETE FROM @T;
   SET @SQL = N'EXEC sp_estimate_data_compression_savings '''
            + @s_name + N''', ''' + @o_name + N''', '
            + CAST(@idxid AS NVARCHAR(16)) +', NULL , ''ROW'';';
PRINT @SQL --> pour vrification, peut tre supprim !
   INSERT INTO @T
   EXEC (@SQL);
   INSERT INTO @F
   SELECT *, 'ROW' FROM @T;
   DELETE FROM @T;
   FETCH C INTO @s_name, @o_name, @idxid;
END

CLOSE C;

DEALLOCATE C;

WITH
T1 AS
( 
SELECT schema_name +'.' + object_name AS table_name, index_id,
       SUM(size_with_current_compression_setting_Ko) AS actual_size_Ko,
       SUM(size_with_requested_compression_setting_Ko) AS comp_size_Ko,
       SUM(sample_size_with_current_compression_setting_Ko) AS actual_sample_size_Ko,
       SUM(sample_size_with_requested_compression_setting_Ko) AS sample_comp_size_Ko,
       GROUPING(index_id) + GROUPING(schema_name +'.' + object_name) AS subtotal_level
FROM   @F
WHERE  compression_method = 'PAGE'
GROUP  BY ROLLUP (schema_name +'.' + object_name, index_id)),
T2 AS
(
SELECT schema_name +'.' + object_name AS table_name, index_id,
       SUM(size_with_current_compression_setting_Ko) AS actual_size_Ko,
       SUM(size_with_requested_compression_setting_Ko) AS comp_size_Ko,
       SUM(sample_size_with_current_compression_setting_Ko) AS actual_sample_size_Ko,
       SUM(sample_size_with_requested_compression_setting_Ko) AS sample_comp_size_Ko,
       GROUPING(index_id) + GROUPING(schema_name +'.' + object_name) AS subtotal_level
FROM   @F
WHERE  compression_method = 'ROW'
GROUP  BY ROLLUP (schema_name +'.' + object_name, index_id))
SELECT T1.table_name, T1.index_id, T1.actual_size_Ko,
       T1.actual_sample_size_Ko,
       T1.comp_size_Ko AS estim_comp_PAGE_size_Ko,
       T2.comp_size_Ko AS estim_comp_ROW_size_Ko,
       T1.sample_comp_size_Ko AS estim_sample_comp_PAGE_size_Ko,
       T2.sample_comp_size_Ko AS estim_sample_comp_ROW_size_Ko,
       CAST(((T1.actual_size_Ko - T1.comp_size_Ko )/NULLIF((T1.actual_size_Ko * 1.0), 0)) * 100 AS DECIMAL(5,2)) AS percent_gain_PAGE_comp,
       CAST(((T1.actual_size_Ko - T2.comp_size_Ko )/NULLIF((T1.actual_size_Ko * 1.0), 0)) * 100 AS DECIMAL(5,2)) AS percent_gain_ROW_comp
FROM   T1 
       INNER JOIN T2
             ON COALESCE(T1.table_name, '') = COALESCE(T2.table_name, '')
                AND COALESCE(T1.index_id, -1) = COALESCE(T2.index_id, -1);
--> NOTA : 
-- 1) une erreur s'est glisse dans la version imprime. La table T2 definie par la requte doit filtrer sur le mode de compression ROW et non PAGE; La requte prsente ici est corrige
-- 2) nous avons ajout  la requte du livre les fonctions NULLIF afin d'viter la division par zro lorsque les tables sont vides